/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Lodging of a location that provides accomodations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Lodging extends com.google.api.client.json.GenericJson {

  /**
   * Physical adaptations made to the property in consideration of varying levels of human physical
   * ability.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Accessibility accessibility;

  /**
   * Amenities and features related to leisure and play.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Activities activities;

  /**
   * All units on the property have at least these attributes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GuestUnitFeatures allUnits;

  /**
   * Features of the property of specific interest to the business traveler.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Business business;

  /**
   * Features of the shared living areas available in this Lodging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LivingArea commonLivingArea;

  /**
   * The ways in which the property provides guests with the ability to access the internet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Connectivity connectivity;

  /**
   * Services and amenities for families and young guests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Families families;

  /**
   * Meals, snacks, and beverages available at the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FoodAndDrink foodAndDrink;

  /**
   * Individual GuestUnitTypes that are available in this Lodging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GuestUnitType> guestUnits;

  static {
    // hack to force ProGuard to consider GuestUnitType used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GuestUnitType.class);
  }

  /**
   * Health and safety measures implemented by the hotel during COVID-19.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HealthAndSafety healthAndSafety;

  /**
   * Conveniences provided in guest units to facilitate an easier, more comfortable stay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Housekeeping housekeeping;

  /**
   * Required. Metadata for the lodging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LodgingMetadata metadata;

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/lodging`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Parking options at the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Parking parking;

  /**
   * Policies regarding guest-owned animals.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Pets pets;

  /**
   * Property rules that impact guests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Policies policies;

  /**
   * Swimming pool or recreational water facilities available at the hotel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Pools pools;

  /**
   * General factual information about the property's physical structure and important dates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Property property;

  /**
   * Conveniences or help provided by the property to facilitate an easier, more comfortable stay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Services services;

  /**
   * Some units on the property have as much as these attributes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GuestUnitFeatures someUnits;

  /**
   * Vehicles or vehicular services facilitated or owned by the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Transportation transportation;

  /**
   * Guest facilities at the property to promote or maintain health, beauty, and fitness.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Wellness wellness;

  /**
   * Physical adaptations made to the property in consideration of varying levels of human physical
   * ability.
   * @return value or {@code null} for none
   */
  public Accessibility getAccessibility() {
    return accessibility;
  }

  /**
   * Physical adaptations made to the property in consideration of varying levels of human physical
   * ability.
   * @param accessibility accessibility or {@code null} for none
   */
  public Lodging setAccessibility(Accessibility accessibility) {
    this.accessibility = accessibility;
    return this;
  }

  /**
   * Amenities and features related to leisure and play.
   * @return value or {@code null} for none
   */
  public Activities getActivities() {
    return activities;
  }

  /**
   * Amenities and features related to leisure and play.
   * @param activities activities or {@code null} for none
   */
  public Lodging setActivities(Activities activities) {
    this.activities = activities;
    return this;
  }

  /**
   * All units on the property have at least these attributes.
   * @return value or {@code null} for none
   */
  public GuestUnitFeatures getAllUnits() {
    return allUnits;
  }

  /**
   * All units on the property have at least these attributes.
   * @param allUnits allUnits or {@code null} for none
   */
  public Lodging setAllUnits(GuestUnitFeatures allUnits) {
    this.allUnits = allUnits;
    return this;
  }

  /**
   * Features of the property of specific interest to the business traveler.
   * @return value or {@code null} for none
   */
  public Business getBusiness() {
    return business;
  }

  /**
   * Features of the property of specific interest to the business traveler.
   * @param business business or {@code null} for none
   */
  public Lodging setBusiness(Business business) {
    this.business = business;
    return this;
  }

  /**
   * Features of the shared living areas available in this Lodging.
   * @return value or {@code null} for none
   */
  public LivingArea getCommonLivingArea() {
    return commonLivingArea;
  }

  /**
   * Features of the shared living areas available in this Lodging.
   * @param commonLivingArea commonLivingArea or {@code null} for none
   */
  public Lodging setCommonLivingArea(LivingArea commonLivingArea) {
    this.commonLivingArea = commonLivingArea;
    return this;
  }

  /**
   * The ways in which the property provides guests with the ability to access the internet.
   * @return value or {@code null} for none
   */
  public Connectivity getConnectivity() {
    return connectivity;
  }

  /**
   * The ways in which the property provides guests with the ability to access the internet.
   * @param connectivity connectivity or {@code null} for none
   */
  public Lodging setConnectivity(Connectivity connectivity) {
    this.connectivity = connectivity;
    return this;
  }

  /**
   * Services and amenities for families and young guests.
   * @return value or {@code null} for none
   */
  public Families getFamilies() {
    return families;
  }

  /**
   * Services and amenities for families and young guests.
   * @param families families or {@code null} for none
   */
  public Lodging setFamilies(Families families) {
    this.families = families;
    return this;
  }

  /**
   * Meals, snacks, and beverages available at the property.
   * @return value or {@code null} for none
   */
  public FoodAndDrink getFoodAndDrink() {
    return foodAndDrink;
  }

  /**
   * Meals, snacks, and beverages available at the property.
   * @param foodAndDrink foodAndDrink or {@code null} for none
   */
  public Lodging setFoodAndDrink(FoodAndDrink foodAndDrink) {
    this.foodAndDrink = foodAndDrink;
    return this;
  }

  /**
   * Individual GuestUnitTypes that are available in this Lodging.
   * @return value or {@code null} for none
   */
  public java.util.List<GuestUnitType> getGuestUnits() {
    return guestUnits;
  }

  /**
   * Individual GuestUnitTypes that are available in this Lodging.
   * @param guestUnits guestUnits or {@code null} for none
   */
  public Lodging setGuestUnits(java.util.List<GuestUnitType> guestUnits) {
    this.guestUnits = guestUnits;
    return this;
  }

  /**
   * Health and safety measures implemented by the hotel during COVID-19.
   * @return value or {@code null} for none
   */
  public HealthAndSafety getHealthAndSafety() {
    return healthAndSafety;
  }

  /**
   * Health and safety measures implemented by the hotel during COVID-19.
   * @param healthAndSafety healthAndSafety or {@code null} for none
   */
  public Lodging setHealthAndSafety(HealthAndSafety healthAndSafety) {
    this.healthAndSafety = healthAndSafety;
    return this;
  }

  /**
   * Conveniences provided in guest units to facilitate an easier, more comfortable stay.
   * @return value or {@code null} for none
   */
  public Housekeeping getHousekeeping() {
    return housekeeping;
  }

  /**
   * Conveniences provided in guest units to facilitate an easier, more comfortable stay.
   * @param housekeeping housekeeping or {@code null} for none
   */
  public Lodging setHousekeeping(Housekeeping housekeeping) {
    this.housekeeping = housekeeping;
    return this;
  }

  /**
   * Required. Metadata for the lodging.
   * @return value or {@code null} for none
   */
  public LodgingMetadata getMetadata() {
    return metadata;
  }

  /**
   * Required. Metadata for the lodging.
   * @param metadata metadata or {@code null} for none
   */
  public Lodging setMetadata(LodgingMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/lodging`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/lodging`
   * @param name name or {@code null} for none
   */
  public Lodging setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Parking options at the property.
   * @return value or {@code null} for none
   */
  public Parking getParking() {
    return parking;
  }

  /**
   * Parking options at the property.
   * @param parking parking or {@code null} for none
   */
  public Lodging setParking(Parking parking) {
    this.parking = parking;
    return this;
  }

  /**
   * Policies regarding guest-owned animals.
   * @return value or {@code null} for none
   */
  public Pets getPets() {
    return pets;
  }

  /**
   * Policies regarding guest-owned animals.
   * @param pets pets or {@code null} for none
   */
  public Lodging setPets(Pets pets) {
    this.pets = pets;
    return this;
  }

  /**
   * Property rules that impact guests.
   * @return value or {@code null} for none
   */
  public Policies getPolicies() {
    return policies;
  }

  /**
   * Property rules that impact guests.
   * @param policies policies or {@code null} for none
   */
  public Lodging setPolicies(Policies policies) {
    this.policies = policies;
    return this;
  }

  /**
   * Swimming pool or recreational water facilities available at the hotel.
   * @return value or {@code null} for none
   */
  public Pools getPools() {
    return pools;
  }

  /**
   * Swimming pool or recreational water facilities available at the hotel.
   * @param pools pools or {@code null} for none
   */
  public Lodging setPools(Pools pools) {
    this.pools = pools;
    return this;
  }

  /**
   * General factual information about the property's physical structure and important dates.
   * @return value or {@code null} for none
   */
  public Property getProperty() {
    return property;
  }

  /**
   * General factual information about the property's physical structure and important dates.
   * @param property property or {@code null} for none
   */
  public Lodging setProperty(Property property) {
    this.property = property;
    return this;
  }

  /**
   * Conveniences or help provided by the property to facilitate an easier, more comfortable stay.
   * @return value or {@code null} for none
   */
  public Services getServices() {
    return services;
  }

  /**
   * Conveniences or help provided by the property to facilitate an easier, more comfortable stay.
   * @param services services or {@code null} for none
   */
  public Lodging setServices(Services services) {
    this.services = services;
    return this;
  }

  /**
   * Some units on the property have as much as these attributes.
   * @return value or {@code null} for none
   */
  public GuestUnitFeatures getSomeUnits() {
    return someUnits;
  }

  /**
   * Some units on the property have as much as these attributes.
   * @param someUnits someUnits or {@code null} for none
   */
  public Lodging setSomeUnits(GuestUnitFeatures someUnits) {
    this.someUnits = someUnits;
    return this;
  }

  /**
   * Vehicles or vehicular services facilitated or owned by the property.
   * @return value or {@code null} for none
   */
  public Transportation getTransportation() {
    return transportation;
  }

  /**
   * Vehicles or vehicular services facilitated or owned by the property.
   * @param transportation transportation or {@code null} for none
   */
  public Lodging setTransportation(Transportation transportation) {
    this.transportation = transportation;
    return this;
  }

  /**
   * Guest facilities at the property to promote or maintain health, beauty, and fitness.
   * @return value or {@code null} for none
   */
  public Wellness getWellness() {
    return wellness;
  }

  /**
   * Guest facilities at the property to promote or maintain health, beauty, and fitness.
   * @param wellness wellness or {@code null} for none
   */
  public Lodging setWellness(Wellness wellness) {
    this.wellness = wellness;
    return this;
  }

  @Override
  public Lodging set(String fieldName, Object value) {
    return (Lodging) super.set(fieldName, value);
  }

  @Override
  public Lodging clone() {
    return (Lodging) super.clone();
  }

}
