/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Forms of payment accepted at the property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PaymentOptions extends com.google.api.client.json.GenericJson {

  /**
   * Cash. The hotel accepts payment by paper/coin currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean cash;

  /**
   * Cash exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cashException;

  /**
   * Cheque. The hotel accepts a printed document issued by the guest's bank in the guest's name as
   * a form of payment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean cheque;

  /**
   * Cheque exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String chequeException;

  /**
   * Credit card. The hotel accepts payment by a card issued by a bank or credit card company. Also
   * known as charge card, debit card, bank card, or charge plate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean creditCard;

  /**
   * Credit card exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creditCardException;

  /**
   * Debit card. The hotel accepts a bank-issued card that immediately deducts the charged funds
   * from the guest's bank account upon processing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean debitCard;

  /**
   * Debit card exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String debitCardException;

  /**
   * Mobile nfc. The hotel has the compatible computer hardware terminal that reads and charges a
   * payment app on the guest's smartphone without requiring the two devices to make physical
   * contact. Also known as Apple Pay, Google Pay, Samsung Pay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mobileNfc;

  /**
   * Mobile nfc exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobileNfcException;

  /**
   * Cash. The hotel accepts payment by paper/coin currency.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCash() {
    return cash;
  }

  /**
   * Cash. The hotel accepts payment by paper/coin currency.
   * @param cash cash or {@code null} for none
   */
  public PaymentOptions setCash(java.lang.Boolean cash) {
    this.cash = cash;
    return this;
  }

  /**
   * Cash exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCashException() {
    return cashException;
  }

  /**
   * Cash exception.
   * @param cashException cashException or {@code null} for none
   */
  public PaymentOptions setCashException(java.lang.String cashException) {
    this.cashException = cashException;
    return this;
  }

  /**
   * Cheque. The hotel accepts a printed document issued by the guest's bank in the guest's name as
   * a form of payment.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCheque() {
    return cheque;
  }

  /**
   * Cheque. The hotel accepts a printed document issued by the guest's bank in the guest's name as
   * a form of payment.
   * @param cheque cheque or {@code null} for none
   */
  public PaymentOptions setCheque(java.lang.Boolean cheque) {
    this.cheque = cheque;
    return this;
  }

  /**
   * Cheque exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getChequeException() {
    return chequeException;
  }

  /**
   * Cheque exception.
   * @param chequeException chequeException or {@code null} for none
   */
  public PaymentOptions setChequeException(java.lang.String chequeException) {
    this.chequeException = chequeException;
    return this;
  }

  /**
   * Credit card. The hotel accepts payment by a card issued by a bank or credit card company. Also
   * known as charge card, debit card, bank card, or charge plate.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCreditCard() {
    return creditCard;
  }

  /**
   * Credit card. The hotel accepts payment by a card issued by a bank or credit card company. Also
   * known as charge card, debit card, bank card, or charge plate.
   * @param creditCard creditCard or {@code null} for none
   */
  public PaymentOptions setCreditCard(java.lang.Boolean creditCard) {
    this.creditCard = creditCard;
    return this;
  }

  /**
   * Credit card exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreditCardException() {
    return creditCardException;
  }

  /**
   * Credit card exception.
   * @param creditCardException creditCardException or {@code null} for none
   */
  public PaymentOptions setCreditCardException(java.lang.String creditCardException) {
    this.creditCardException = creditCardException;
    return this;
  }

  /**
   * Debit card. The hotel accepts a bank-issued card that immediately deducts the charged funds
   * from the guest's bank account upon processing.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDebitCard() {
    return debitCard;
  }

  /**
   * Debit card. The hotel accepts a bank-issued card that immediately deducts the charged funds
   * from the guest's bank account upon processing.
   * @param debitCard debitCard or {@code null} for none
   */
  public PaymentOptions setDebitCard(java.lang.Boolean debitCard) {
    this.debitCard = debitCard;
    return this;
  }

  /**
   * Debit card exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getDebitCardException() {
    return debitCardException;
  }

  /**
   * Debit card exception.
   * @param debitCardException debitCardException or {@code null} for none
   */
  public PaymentOptions setDebitCardException(java.lang.String debitCardException) {
    this.debitCardException = debitCardException;
    return this;
  }

  /**
   * Mobile nfc. The hotel has the compatible computer hardware terminal that reads and charges a
   * payment app on the guest's smartphone without requiring the two devices to make physical
   * contact. Also known as Apple Pay, Google Pay, Samsung Pay.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMobileNfc() {
    return mobileNfc;
  }

  /**
   * Mobile nfc. The hotel has the compatible computer hardware terminal that reads and charges a
   * payment app on the guest's smartphone without requiring the two devices to make physical
   * contact. Also known as Apple Pay, Google Pay, Samsung Pay.
   * @param mobileNfc mobileNfc or {@code null} for none
   */
  public PaymentOptions setMobileNfc(java.lang.Boolean mobileNfc) {
    this.mobileNfc = mobileNfc;
    return this;
  }

  /**
   * Mobile nfc exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobileNfcException() {
    return mobileNfcException;
  }

  /**
   * Mobile nfc exception.
   * @param mobileNfcException mobileNfcException or {@code null} for none
   */
  public PaymentOptions setMobileNfcException(java.lang.String mobileNfcException) {
    this.mobileNfcException = mobileNfcException;
    return this;
  }

  @Override
  public PaymentOptions set(String fieldName, Object value) {
    return (PaymentOptions) super.set(fieldName, value);
  }

  @Override
  public PaymentOptions clone() {
    return (PaymentOptions) super.clone();
  }

}
