/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Output only. Represents a review for a location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Review extends com.google.api.client.json.GenericJson {

  /**
   * The body of the review as plain text with markups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comment;

  /**
   * The timestamp for when the review was written.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The resource name. For Review it is of the form
   * `accounts/{account_id}/locations/{location_id}/reviews/{review_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The encrypted unique identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewId;

  /**
   * The owner/manager of this location's reply to this review.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReviewReply reviewReply;

  /**
   * The author of the review.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Reviewer reviewer;

  /**
   * The star rating of the review.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String starRating;

  /**
   * The timestamp for when the review was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * The body of the review as plain text with markups.
   * @return value or {@code null} for none
   */
  public java.lang.String getComment() {
    return comment;
  }

  /**
   * The body of the review as plain text with markups.
   * @param comment comment or {@code null} for none
   */
  public Review setComment(java.lang.String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * The timestamp for when the review was written.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * The timestamp for when the review was written.
   * @param createTime createTime or {@code null} for none
   */
  public Review setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The resource name. For Review it is of the form
   * `accounts/{account_id}/locations/{location_id}/reviews/{review_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name. For Review it is of the form
   * `accounts/{account_id}/locations/{location_id}/reviews/{review_id}`
   * @param name name or {@code null} for none
   */
  public Review setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The encrypted unique identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewId() {
    return reviewId;
  }

  /**
   * The encrypted unique identifier.
   * @param reviewId reviewId or {@code null} for none
   */
  public Review setReviewId(java.lang.String reviewId) {
    this.reviewId = reviewId;
    return this;
  }

  /**
   * The owner/manager of this location's reply to this review.
   * @return value or {@code null} for none
   */
  public ReviewReply getReviewReply() {
    return reviewReply;
  }

  /**
   * The owner/manager of this location's reply to this review.
   * @param reviewReply reviewReply or {@code null} for none
   */
  public Review setReviewReply(ReviewReply reviewReply) {
    this.reviewReply = reviewReply;
    return this;
  }

  /**
   * The author of the review.
   * @return value or {@code null} for none
   */
  public Reviewer getReviewer() {
    return reviewer;
  }

  /**
   * The author of the review.
   * @param reviewer reviewer or {@code null} for none
   */
  public Review setReviewer(Reviewer reviewer) {
    this.reviewer = reviewer;
    return this;
  }

  /**
   * The star rating of the review.
   * @return value or {@code null} for none
   */
  public java.lang.String getStarRating() {
    return starRating;
  }

  /**
   * The star rating of the review.
   * @param starRating starRating or {@code null} for none
   */
  public Review setStarRating(java.lang.String starRating) {
    this.starRating = starRating;
    return this;
  }

  /**
   * The timestamp for when the review was last modified.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * The timestamp for when the review was last modified.
   * @param updateTime updateTime or {@code null} for none
   */
  public Review setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public Review set(String fieldName, Object value) {
    return (Review) super.set(fieldName, value);
  }

  @Override
  public Review clone() {
    return (Review) super.clone();
  }

}
