/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * An interval of time, inclusive. It must contain all fields to be valid.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TimeInterval extends com.google.api.client.json.GenericJson {

  /**
   * The end date of this period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date endDate;

  /**
   * The end time of this period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay endTime;

  /**
   * The start date of this period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date startDate;

  /**
   * The start time of this period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay startTime;

  /**
   * The end date of this period.
   * @return value or {@code null} for none
   */
  public Date getEndDate() {
    return endDate;
  }

  /**
   * The end date of this period.
   * @param endDate endDate or {@code null} for none
   */
  public TimeInterval setEndDate(Date endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The end time of this period.
   * @return value or {@code null} for none
   */
  public TimeOfDay getEndTime() {
    return endTime;
  }

  /**
   * The end time of this period.
   * @param endTime endTime or {@code null} for none
   */
  public TimeInterval setEndTime(TimeOfDay endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The start date of this period.
   * @return value or {@code null} for none
   */
  public Date getStartDate() {
    return startDate;
  }

  /**
   * The start date of this period.
   * @param startDate startDate or {@code null} for none
   */
  public TimeInterval setStartDate(Date startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * The start time of this period.
   * @return value or {@code null} for none
   */
  public TimeOfDay getStartTime() {
    return startTime;
  }

  /**
   * The start time of this period.
   * @param startTime startTime or {@code null} for none
   */
  public TimeInterval setStartTime(TimeOfDay startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public TimeInterval set(String fieldName, Object value) {
    return (TimeInterval) super.set(fieldName, value);
  }

  @Override
  public TimeInterval clone() {
    return (TimeInterval) super.clone();
  }

}
